﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_IntrusiveList.h>

#include <nn/apm/apm_ManagerImpl.h>
#include <nn/apm/server/apm.h>

#include "apm_PerformanceList.h"
#include "apm_PerformanceServer.h"
#include "apm_SessionImpl.h"

namespace nn { namespace apm { namespace server {

// ISession インタフェースクラス。
class Session :
    public nn::util::IntrusiveListBaseNode<Session>
{
public:

    virtual PerformanceConfiguration GetPerformanceConfiguration(nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT
    {
        NN_UNUSED(performanceMode);
        return PerformanceConfiguration_Invalid;
    }

    virtual nn::Result SetPerformanceConfiguration(nn::apm::PerformanceMode performanceMode, nn::apm::PerformanceConfiguration performanceConfiguration) NN_NOEXCEPT
    {
        NN_UNUSED(performanceMode);
        NN_UNUSED(performanceConfiguration);
        NN_RESULT_SUCCESS;
    }

    virtual nn::Result GetPerformanceConfiguration(nn::sf::Out<nn::apm::PerformanceConfiguration> pOutPerformanceConfiguration, nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT
    {
        NN_UNUSED(performanceMode);
        *pOutPerformanceConfiguration = PerformanceConfiguration_Invalid;
        NN_RESULT_SUCCESS;
    }
};

// ISession 実装クラス。
class SessionImpl :
    public Session
{
public:
    explicit SessionImpl(ManagerImpl* pParent) NN_NOEXCEPT
        : m_Parent(pParent, true)
    {
    }

private:
    nn::sf::SharedPointer<ManagerImpl> m_Parent;
};

// ISession 実装クラス。
class SessionPrivilegedImpl :
    public Session
{
public:
    explicit SessionPrivilegedImpl(ManagerPrivilegedImpl* pParent) NN_NOEXCEPT
        : m_Parent(pParent, true)
    {
    }

private:
    nn::sf::SharedPointer<ManagerPrivilegedImpl> m_Parent;
};

}}} // namespace nn::apm::server
