﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "apm_FirmwareDebugSettingsAccessor.h"
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn { namespace apm { namespace server {

class FirmwareDebugSettingsAccessor {

private:
    static const size_t TemporaryBufferSizeForString = 32;

public:
    //! Firmware Debug Settings を読む。
    template <typename T>
    void ReadSetting(T* pOutValue, const char* pName) NN_NOEXCEPT
    {
        size_t targetSize = nn::settings::fwdbg::GetSettingsItemValueSize("apm", pName);
        if ( 0 == targetSize )
        {
            NN_DETAIL_APM_WARN("Failed to read %s (Value is not written)\n", pName);
            return;
        }
        else if ( sizeof(T) != targetSize )
        {
            NN_DETAIL_APM_WARN("Failed to read %s (data size does not match). expected=%d, actual=%d\n", pName, sizeof(T), targetSize);
            return;
        }

        T temporaryValue;
        if ( sizeof(T) != (nn::settings::fwdbg::GetSettingsItemValue(&temporaryValue, sizeof(T), "apm", pName)) )
        {
            NN_DETAIL_APM_WARN("Failed to read %s.\n", pName);
        }
        else
        {
            *pOutValue = temporaryValue;
        }
    }

    //! 文字列型の Firmware Debug Settings を読む。
    void ReadSettingString(char* pOutBuffer, size_t outputBufferSize, const char* pName) NN_NOEXCEPT;
};

}}} // namespace nn::apm::server
