﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.am.service
{
    [CppRefPath(Location.FunctionsSfdlPath)]
    public interface IGlobalStateController : IServiceObject
    {
        #region 暫定: スリープ要求

        /// <summary>
        /// システムスリープへ遷移するための事前確認を行なう
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// TODO: スリープ関連（近いうちに I/F が変わる予定）
        ///
        /// 本メソッド発行後は全てのアプリとアプリケーションに
        /// Message_ChangeIntoSleep メッセージが通知され、それぞれが、
        /// AllowToEnterSleep() もしくは DisallowToEnterSleep() で返答します。
        ///
        /// 全てが AllowToEnterSleep() で返答された場合は、
        /// 本メソッド呼出元に Message_ApprovedSleepRequest が通知され、
        /// 1 つでも DisallowToEnterSleep() で返答された場合は、
        /// 本メソッド呼出元に Message_RejectedSleepRequest が通知されます。
        /// また、このシーケンス中にアボートしたアプレット等があった場合は、
        /// Message_CanceledSleepRequest が通知されます。
        ///
        /// シーケンス図は以下のページを参照。
        /// http://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=106340132
        /// </remarks>
        [MethodId(0)]
        Result RequestToEnterSleep();

        #endregion

        /// <summary>
        /// システムをスリープへ遷移させる
        /// </summary>
        /// <returns>
        /// </returns>
        /// <remarks>
        /// TODO: スリープ関連（近いうちに I/F が変わる予定）
        ///
        /// 本メソッドは RequestToEnterSleep() の手続きにおいて、
        /// Message_ApprovedSleepRequest が得られたことが事前条件となります。
        /// その後に本メソッドを呼ぶと、システムスリープへ入ります。
        /// システムスリープから復帰後は、全アプリとアプレットに対して、
        /// Message_AwakeFromSleep が通知されます。
        /// </remarks>
        [MethodId(1)]
        Result EnterSleep();

        /// <summary>
        /// スリープシーケンスを開始する
        /// </summary>
        /// <returns></returns>
        [MethodId(2)]
        Result StartSleepSequence(bool needsFinishedMssage);

        /// <summary>
        /// シャットダウンシーケンスを開始する
        /// </summary>
        /// <returns></returns>
        [MethodId(3)]
        Result StartShutdownSequence();

        /// <summary>
        /// 再起動シーケンスを開始する
        /// </summary>
        /// <returns></returns>
        [MethodId(4)]
        Result StartRebootSequence();

        /// <summary>
        /// 無操作状態検出時の制御パラメータ設定値を読み出して反映させる
        /// </summary>
        /// <returns></returns>
        [MethodId(10)]
        Result LoadAndApplyIdlePolicySettings();

        [MethodId(11)]
        Result NotifyCecSettingsChanged();

        [MethodId(12)]
        Result SetDefaultHomeButtonLongPressTime(int64_t longPressTimeInNanoSeconds);

        [MethodId(13)]
        Result UpdateDefaultDisplayResolution();

        [MethodId(14)]
        Result ShouldSleepOnBoot(Out<bool> outIsShouldSleepOnBoot);

        [MethodId(15)]
        Result GetHdcpAuthenticationFailedEvent(Out<NativeHandle> outValue);
    }
}
