﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/window/am_SleepWindowController.h>

#include <nn/am/service/window/am_WindowSystem.h>

namespace nn { namespace am { namespace service { namespace window {

void SleepWindowController::UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    if (newStatus.lcdOff && !oldStatus.lcdOff)
    {
        p->GetTransiter()->SetLcd(false);
    }
    if (newStatus.lockingSleep && !oldStatus.lockingSleep)
    {
        p->GetTransiter()->OnSleepLockAcquired();
    }
    if (newStatus.clockRequestedApprovalForSleep > 0)
    {
        if (newStatus.clockRequestedApprovalForSleep != oldStatus.clockRequestedApprovalForSleep)
        {
            p->GetTransiter()->RequestApprovalForSleep(newStatus.clockRequestedApprovalForSleep);
        }
    }
    if (newStatus.isSleeping && !oldStatus.isSleeping)
    {
        p->GetTransiter()->BeforeSleepSystem();
    }
}

void SleepWindowController::UpdatePositive(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT
{
    if (!newStatus.isSleeping && oldStatus.isSleeping)
    {
        p->GetTransiter()->AfterSleepSystem();
    }
    if (!newStatus.lockingSleep && oldStatus.lockingSleep)
    {
        p->GetTransiter()->OnSleepLockReleased();
    }
    if (!newStatus.lcdOff && oldStatus.lcdOff)
    {
        p->GetTransiter()->SetLcd(true);
    }
    if (newStatus.nextSleepSequenceStage != oldStatus.nextSleepSequenceStage)
    {
        p->GetTransiter()->TransitSleepSequence(newStatus.nextSleepSequenceStage);
    }
}

}}}}
