﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "am_FatalEvent.h"

#include <nn/nn_Common.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/fatal/fatal_ApiPrivate.h>

namespace nn { namespace am { namespace service {

FatalEvent::FatalEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT
    : m_pAppletSystem(pAppletSystem)
{
    fatal::GetFatalEvent(&m_Event);
    os::InitializeMultiWaitHolder(&m_Holder, m_Event.GetBase());
    m_Holder.userData = reinterpret_cast<uintptr_t>(this);
}

FatalEvent::~FatalEvent() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder(&m_Holder);
}

void FatalEvent::FatalEventHandler() NN_NOEXCEPT
{
    if (!m_Event.TryWait())
    {
        return;
    }
    m_Event.Clear();
    NN_AM_SERVICE_LOG(error, "fatal occurred.\n");
    m_pAppletSystem->GetWindowManager()->NotifyFatal(true);
}

}}}
