﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/am_CallingWindableApplet.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <utility>
#include <memory>
#include <mutex>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_Exchange.h>

namespace nn { namespace am { namespace service {

void CallingWindableApplet::ReserveToStartAndWaitAndUnwindThis(std::shared_ptr<core::Applet> p) NN_NOEXCEPT
{
    std::unique_lock<decltype(m_Mutex)> lk(m_Mutex);
    this->m_NeedsUnwind = true;
    this->m_ReservedApplet = std::move(p);
}

void CallingWindableApplet::ReserveToStartAndWait(std::shared_ptr<core::Applet> p) NN_NOEXCEPT
{
    std::unique_lock<decltype(m_Mutex)> lk(m_Mutex);
    this->m_NeedsUnwind = false;
    this->m_ReservedApplet = std::move(p);
}

void CallingWindableApplet::ReserveToWindAndUnwind() NN_NOEXCEPT
{
    std::unique_lock<decltype(m_Mutex)> lk(m_Mutex);
    this->m_NeedsUnwind = true;
    this->m_ReservedApplet.reset();
}

void CallingWindableApplet::ClearReservation() NN_NOEXCEPT
{
    std::unique_lock<decltype(m_Mutex)> lk(m_Mutex);
    this->m_NeedsUnwind = false;
    this->m_ReservedApplet.reset();
}

bool CallingWindableApplet::DoReservation() NN_NOEXCEPT
{
    std::unique_lock<decltype(m_Mutex)> lk(m_Mutex);
    auto p = std::move(m_ReservedApplet);
    auto needsUnwind = util::Exchange(&m_NeedsUnwind, false);
    lk.unlock();

    if (p)
    {
        NN_AM_SERVICE_APPLET_LOG(seq, this, "start resevation applet: " NN_AM_SERVICE_DIAGNOSTICS_APPLET_STRING_FORMAT, NN_AM_SERVICE_DIAGNOSTICS_APPLET_STRING_FORMAT_PARAMETER(p));
        p->Start();
        p->Join();
        NN_AM_SERVICE_APPLET_LOG(seq, this, "join resevation applet: " NN_AM_SERVICE_DIAGNOSTICS_APPLET_STRING_FORMAT, NN_AM_SERVICE_DIAGNOSTICS_APPLET_STRING_FORMAT_PARAMETER(p));
    }
    return needsUnwind;
}

}}}
