﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/am_BtmWrapper.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/util/util_Optional.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/am/service/am_ServiceDiagnostics.h>
#include <nn/am/service/am_StuckChecker.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
#include <nn/btm/btm_Api.h>
#endif

#include <mutex>

namespace nn { namespace am { namespace service {

namespace {

    // btm
    os::SdkMutex m_BtmMutex;
    util::optional<WirelessPriorityMode> m_pCurrentWirelessPriorityMode{util::nullopt};

}

void BtmSetWirelessPriorityMode(WirelessPriorityMode mode) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    std::lock_guard<decltype(m_BtmMutex)> lk(m_BtmMutex);
    if (m_pCurrentWirelessPriorityMode != mode)
    {
        m_pCurrentWirelessPriorityMode = mode;
        bool isEnable = (mode == WirelessPriorityMode_OptimizedForWlan);
        NN_AM_SERVICE_LOG(call, "btm::EnableSlotSaving(%s)\n", isEnable ? "true" : "false");
        NN_AM_SERVICE_STUCK_CHECKED(btm_EnableSlotSaving, 60, btm::EnableSlotSaving(isEnable));
    }
#else
    NN_UNUSED(mode);
#endif
}

void BtmRegisterAppletResourceUserId(applet::AppletResourceUserId aruid, applet::AppletId appletId) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NN_AM_SERVICE_STUCK_CHECKED(btm_RegisterAruid, 60, btm::RegisterAppletResourceUserId(aruid, appletId));
#else
    NN_UNUSED(aruid);
    NN_UNUSED(appletId);
#endif
}

void BtmUnregisterAppletResourceUserId(applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NN_AM_SERVICE_STUCK_CHECKED(btm_UnregisterAruid, 60, btm::UnregisterAppletResourceUserId(aruid));
#else
    NN_UNUSED(aruid);
#endif
}

void BtmSetAppletResourceUserId(applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NN_AM_SERVICE_STUCK_CHECKED(btm_SetAruid, 60, btm::SetAppletResourceUserId(aruid));
#else
    NN_UNUSED(aruid);
#endif
}

}}}
