﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/am/service/am_AppletProxy.h>

#include <nn/am/am_ResultPrivate.h>

namespace nn { namespace am { namespace service {

AppletProxy::~AppletProxy() NN_NOEXCEPT
{
}

nn::Result AppletProxy::GetApplicationFunctions(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IApplicationFunctions>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetProcessWindingController(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IProcessWindingController>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetAudioController(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IAudioController>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetDisplayController(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IDisplayController>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetLibraryAppletCreator(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ILibraryAppletCreator>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetCommonStateGetter(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ICommonStateGetter>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetSelfController(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ISelfController>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetWindowController(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IWindowController>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetHomeMenuFunctions(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IHomeMenuFunctions>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetGlobalStateController(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IGlobalStateController>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetApplicationCreator(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IApplicationCreator>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::OpenLibraryAppletSelfAccessor(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::ILibraryAppletSelfAccessor>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetOverlayFunctions(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IOverlayFunctions>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

nn::Result AppletProxy::GetDebugFunctions(nn::sf::Out<nn::sf::SharedPointer<nn::am::service::IDebugFunctions>>) NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultInvalidAppletProxyCall());
}

}}}
