﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os/os_MultipleWait.h>

#include "am_ApmEvent.h"

namespace nn { namespace am { namespace service {

//-----------------------------------------------------------------------------
//  コンストラクタ
//
ApmEvent::ApmEvent(AppletSystem* pAppletSystem) NN_NOEXCEPT
      : m_pAppletSystem( pAppletSystem )
{
    apm::GetPerformanceEvent( &m_ApmEvent, apm::EventTarget_PerformanceModeChanged, os::EventClearMode_AutoClear );
    os::InitializeMultiWaitHolder( &m_ApmEventHolder, &m_ApmEvent );
    m_ApmEventHolder.userData = reinterpret_cast<uintptr_t>(this);
}


//-----------------------------------------------------------------------------
//  デストラクタ
//
ApmEvent::~ApmEvent() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder( &m_ApmEventHolder );
}


//-----------------------------------------------------------------------------
//  ApmEvent ハンドラ関数（多重待ち解除時に呼ばれる）
//
void ApmEvent::ApmEventHandler() NN_NOEXCEPT
{
    if ( !os::TryWaitSystemEvent( &m_ApmEvent ) )
    {
        return;
    }
    NotifyPerformanceModeChanged();
}


//-----------------------------------------------------------------------------

}}} // namespace nn::am::service

