﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ahid_Hdr.h"

namespace nn {
namespace ahid {
namespace hdr {

//////////////////////////////////////////////////////////////////////////////
//  public functions
//////////////////////////////////////////////////////////////////////////////
Result HdrMutex::Initialize() NN_NOEXCEPT
{
    nn::os::InitializeMutex(&m_Mutex, false, 0);

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrMutex::Finalize() NN_NOEXCEPT
{
    nn::os::FinalizeMutex(&m_Mutex);

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrMutex::Lock() NN_NOEXCEPT
{
    nn::os::LockMutex(&m_Mutex);

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result HdrMutex::Unlock() NN_NOEXCEPT
{
    nn::os::UnlockMutex(&m_Mutex);

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
//  private functions
//////////////////////////////////////////////////////////////////////////////


}   // hdr
}   // ahid
}   // nn
