﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace ahid {
namespace hdr {

enum
{
    HdrDeviceCountMax = HdrEntriesCountMax,
};

struct ServerDeviceParameters       //!< Device parameters used to attach device to HDR
{
    DeviceParameters    deviceParameters;
    uint64_t            attachTime;         //!< devices attached on ticks

};


class HdrDevice
{

    NN_DISALLOW_COPY(HdrDevice);
    NN_DISALLOW_MOVE(HdrDevice);

public:

    HdrDevice() NN_NOEXCEPT {};
    ~HdrDevice() NN_NOEXCEPT {};

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    Result Attach(int index, DeviceParameters* pDeviceParameters) NN_NOEXCEPT;
    Result Detach(int index) NN_NOEXCEPT;
    Result GetDeviceParameters(int index, DeviceParameters* pDeviceParameters) NN_NOEXCEPT;
    Result GetServerDeviceParameters(int index, ServerDeviceParameters* pServerDeviceParameters) NN_NOEXCEPT;

private:

    ServerDeviceParameters  m_ServerDeviceParameters[HdrDeviceCountMax];
};

}   // namespace hdr
}   // namespace ahid
}   // namespace nn
