﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/am/am_Shim.h>

#include <nn/applet/applet_Types.h>
#include <nn/applet/applet_Result.h>

#include <nn/ae/ae_SleepApi.h>
#include <nn/ae/ae_Result.h>
#include <nn/ae/ae_Types.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace ae {

//-----------------------------------------------------------------------------

namespace {

    void WaitForAcquiredSleepLock() NN_NOEXCEPT
    {
        sf::NativeHandle handle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->GetAcquiredSleepLockEvent(&handle));
        os::SystemEvent e;
        e.AttachReadableHandle(handle.GetOsHandle(), false, os::EventClearMode_ManualClear);
        e.Wait();
    }

}

Result StartSleepSequence() NN_NOEXCEPT
{
    return am::GetGlobalStateController()->StartSleepSequence(true);
}

void BeginSleepHandling() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->RequestToAcquireSleepLock());
    WaitForAcquiredSleepLock();
}

void AllowToEnterSleepAndWait() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->ReleaseSleepLockTransiently());
    WaitForAcquiredSleepLock();
}

void EndSleepHandling() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->ReleaseSleepLock());
}

Result StartShutdownSequence() NN_NOEXCEPT
{
    return am::GetGlobalStateController()->StartShutdownSequence();
}

Result StartRebootSequence() NN_NOEXCEPT
{
    return am::GetGlobalStateController()->StartRebootSequence();
}

}}  // namespace nn::ae

