﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>
#include <nn/account/baas/account_BaasTypes.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/account/profile/account_ProfileStorage.h>

namespace nn { namespace account { namespace profile {

class ProfileAdaptor
{
public:
    enum EvaluationResult
    {
        EvaluationResult_Stay,
        EvaluationResult_Import,
        EvaluationResult_Export,
    };

private:
    ProfileStorage* const m_pStorage;
    const Uid m_Uid;
    const bool m_ForceImport;

public:
    ProfileAdaptor(ProfileStorage* pStorage, const Uid& uid) NN_NOEXCEPT;
    ProfileAdaptor(ProfileStorage* pStorage, const Uid& uid, bool forceImport) NN_NOEXCEPT;

    // BaaS -> Local 方向
    Result Decode(ProfileBase* pOut, UserData* pOutUserData, const baas::UserProfileBase& remote) const NN_NOEXCEPT;
    Result Evaluate(EvaluationResult* pOut, const ProfileBase& remote) const NN_NOEXCEPT;
    Result Import(const ProfileBase& remote, const UserData& remoteUserData, const void* image, size_t imageSize) const NN_NOEXCEPT;

    // Local -> BaaS 方向
    Result AcquireProfile(baas::UserProfileBase* pOut) const NN_NOEXCEPT;
    Result CreateProfileImageCache(detail::Uuid* pOut, void* buffer, size_t bufferSize) const NN_NOEXCEPT;
};

}}}
