﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/http/account_ResultForHttp.h>
#include <nn/http/stream/http_WebApiAccessorBase.h>

namespace nn { namespace account { namespace http {

const char* GetUserAgent() NN_NOEXCEPT;

Result HandleCurlError(CURLcode e) NN_NOEXCEPT;
Result HandleHttpStatusCode(long status) NN_NOEXCEPT;

const nn::http::stream::WebApiAccessorBase::ErrorHandler DefaultErrorHandler = {
    HandleCurlError,
    HandleHttpStatusCode,
};

#define NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(_subname, _name, _r) \
    if (_subname :: _name ::Includes(_r)) \
    { \
        NN_RESULT_THROW(::nn::account::http:: _name ()); \
    }

#define NN_ACCOUNT_HTTP_CONVERT_HTTP_STATUS_RESULT_IF_MATCH(subname, r) \
    do \
    { \
        NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpUnsupportedStatusCode, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus4xx, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus5xx, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus400BadRequest, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus401Unauthorized, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus403Forbidden, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus404NotFound, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus405MethodNotAllowed, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus406NotAcceptable, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus407ProxyAuthenticationRequired, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus408RequestTimeout, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus409Conflict, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus410Gone, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus411LengthRequired, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus412PreconditionFailed, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus413PayloadTooLarge, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus414UriTooLong, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus415UnsupportedMediaType, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus416RangeNotSatisfiable, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus417ExpectationFailed, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus500InternalServerError, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus501NotImplemented, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus502BadGateway, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus503ServiceUnavailable, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus504GatewayTimeout, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultHttpStatus505HttpVersionNotSupported, r) \
        \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultCurlErrorCouldntResolveProxy, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultCurlErrorCouldntResolveHost, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultCurlErrorCouldntConnect, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultCurlErrorOperationTimedout, r) \
        else NN_ACCOUNT_HTTP_CONVERT_RESULT_IF_MATCH(subname, ResultCurlErrorSslConnectError, r) \
    } while (NN_STATIC_CONDITION(false))

}}} // ~namespace nn::account::http
