﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/account/account_TypesForSelectorImpl.h>

namespace nn {
namespace account {
namespace detail {

#if defined(NN_SDK_BUILD_RELEASE)
#define NN_ACCOUNT_DETAIL_ASSERT_OBJECT_IS_VALID(...)

#else // NN_SDK_BUILD_RELEASE
#define NN_ACCOUNT_DETAIL_ASSERT_OBJECT_IS_VALID(pObj, name) \
    do \
    { \
        if (!(pObj)->m_Ptr) \
        { \
            NN_ABORT("[account] Accessing uninitialized instance of " #name "");\
        } \
    } while (NN_STATIC_CONDITION(false))


#endif

bool IsInitialized() NN_NOEXCEPT;

/*  UIなしでユーザーを一意に選択可能な場合、 pOut には有効なユーザー識別子が格納される
    そうでない場合、 pOut には無効なユーザー識別子が格納される。

    処理に失敗した場合は nn::ResultSuccess 以外が返却される。
 */
Result TrySelectUserWithoutInteraction(Uid* pOut, bool isNetworkServiceAccountRequired) NN_NOEXCEPT;

// アプリケーションの起動時に指定されたユーザーアカウントを取得します。
const uint32_t PreselectionInfoMagicNumber = 0xc79497ca;
Uid TryPopPreselectedUser() NN_NOEXCEPT;

Result CheckInternetAvailability() NN_NOEXCEPT;

Result StartPselApplet(const UiSettings& settings) NN_NOEXCEPT;
Result StartPselApplet(const UiSettings& settings, const void* inData, size_t inDataBytes) NN_NOEXCEPT;
Result ShowUserSelectorCommon(Uid* pOut, const UiSettings& settings) NN_NOEXCEPT;

} // ~namespace nn::account::detail
}
}
