﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/detail/account_ReferenceContext.h>

#if defined(NN_BUILD_TARGET_PLATFORM_NX)
#include <nn/ovln/ovln_SenderForOverlay.h>
#endif

namespace nn { namespace account { namespace detail {

Result SendOvlnNotification(const Uid& uid, ovln::format::AccountUserStateChangeKind kind) NN_NOEXCEPT
{
#if defined(NN_BUILD_TARGET_PLATFORM_NX)
    ovln::SenderForOverlayType sender;
    NN_RESULT_DO(ovln::InitializeSenderForValue(&sender));
    NN_UTIL_SCOPE_EXIT
    {
        ovln::FinalizeSender(&sender);
    };

    ovln::format::AccountUserStateChangeData change;
    change.kind = kind;
    change.uid = uid;

    ovln::Message message;
    message.tag = ovln::format::AccountUserStateChangeTag;
    std::memcpy(&message.data, &change, sizeof(change));
    message.dataSize = sizeof(change);

    auto sent = ovln::Send(&sender, message);
    if (!sent)
    {
        NN_DETAIL_ACCOUNT_WARN("<!> ovln::Send() returned false\n");
    }
#else
    NN_UNUSED(&uid);
    NN_UNUSED(kind);
#endif
    NN_RESULT_SUCCESS;
}

}}} // ~namespace nn::account::detail
