﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_ApiForSystemServices.h>

#include <nn/account/account_IAccountService.sfdl.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_IServiceObject.h>
#include <nn/sf/sf_NativeHandle.h>

#include "detail/account_ShimLibraryUtility.h"

namespace nn { namespace account {

Notifier& Notifier::Swap(Notifier& rhs) NN_NOEXCEPT
{
    std::swap(m_Ptr, rhs.m_Ptr);
    return *this;
}

Notifier::Notifier(detail::INotifier* ptr) NN_NOEXCEPT
    : m_Ptr(ptr)
{
}

Notifier::Notifier() NN_NOEXCEPT
    : m_Ptr(nullptr)
{
}
Notifier::Notifier(Notifier&& rhs) NN_NOEXCEPT
    : m_Ptr(rhs.m_Ptr)
{
    rhs.m_Ptr = nullptr;
}
Notifier::~Notifier() NN_NOEXCEPT
{
    if (m_Ptr != nullptr)
    {
        sf::ReleaseSharedObject(m_Ptr);
    }
}
Notifier& Notifier::operator=(Notifier&& rhs) NN_NOEXCEPT
{
    Notifier tmp(std::move(rhs));
    tmp.Swap(*this);
    return *this;
}
Result Notifier::GetSystemEvent(os::SystemEvent* pOutEvent) NN_NOEXCEPT
{
    NN_ACCOUNT_DETAIL_ASSERT_OBJECT_IS_VALID(this, Notifier);
    NN_SDK_REQUIRES(pOutEvent);

    sf::NativeHandle sfHandle;
    NN_RESULT_DO(m_Ptr->GetSystemEvent(&sfHandle));
    pOutEvent->AttachReadableHandle(os::NativeHandle(sfHandle.GetOsHandle()), sfHandle.IsManaged(), os::EventClearMode_ManualClear);
    sfHandle.Detach();
    NN_RESULT_SUCCESS;
}

}} // ~namespace nn::account
