﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_Api.h>
#include <nn/account/account_Types.h>
#include <nn/account/account_TypesForSystemServices.h>
#include "detail/account_ShimLibraryUtility.h"

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>

namespace nn { namespace account {

PreselectionInfo MakePreselectionInfo(const Uid& uid) NN_NOEXCEPT
{
    int count;
    Uid users[UserCountMax];
    NN_ABORT_UNLESS_RESULT_SUCCESS(ListAllUsers(&count, users, sizeof(users) / sizeof(users[0])));
    for (auto i = 0; i < count; ++ i)
    {
        if (users[i] == uid)
        {
            PreselectionInfo p = {detail::PreselectionInfoMagicNumber, 1, {uid}};
            return p;
        }
    }
    NN_ABORT("[nn::account] Given user account does not exist\n");
}

}} // ~namespace nn::account
