﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * tmp451 のデバイス固有値の定義
 */

#include <nn/nn_Common.h>

#include <nnd/tmp451/tmp451.h>

namespace nnd {
namespace tmp451 {
namespace detail {

const size_t    RegSize     = 1;    // レジスタ１つ分のサイズ。
const int       DecimalUnit = 625;  // 小数部で取得できる値の分解能。0.0625℃。

/*
 * Register(Read)
 */
enum class RegRead: uint8_t
{
    LocalTempInt        = 0x00,
    RemoteTempInt,
    Status,
    Configuration,
    ConversionRate,
    LocalHighLimit,
    LocalLowLimit,
    RemoteHighlimitInt,
    RemoteLowlimitInt,

    RemoteTempDec           = 0x10,
    RemoteOffsetInt,
    RemoteOffsetDec,
    RemoteHighLimitDec,
    RemoteLowLimitDec,
    LocalTempLsb,

    RemoteThermLimit        = 0x19,
    LocalThermLimit         = 0x20,
    ThermHysterisis,
    ConsecutiveAlert,
    EtaFactorCorrection,
    DigitalFilterControl,

    ManufactureId           = 0xFE,
};

/*
 * Register(Write)
 */
enum class RegWrite: uint8_t
{
    Configuration           = 0x09,
    ConversionRate,
    LocalHighLimit,
    LocalLowLimit,
    RemoteHighlimitInt,
    RemoteLowlimitInt,
    OneShot,

    RemoteOffsetInt         = 0x11,
    RemoteOffsetDec,
    RemoteHighLimitDec,
    RemoteLowLimitDec,

    RemoteThermLimit        = 0x19,
    LocalThermLimit         = 0x20,
    ThermHysterisis,
    ConsecutiveAlert,
    EtaFactorCorrection,
    DigitalFilterControl,
};


} // detail
} // tmp451
} // nnd
