﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_DeviceCode.h>

#include <nn/ddsf/ddsf_IDriver.h> // To call IDriver::ForEachDevice
#include <nn/gpio/gpio_Type.h>
#include <nn/gpio/driver/gpio_PadAccessorDev.h> // For WakePinDebugMode

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
#include <nne/wec/wec.h>
#endif

#include "gpioTegra_Pad.h"

namespace nnd { namespace gpio { namespace tegra { namespace detail {

class SuspendHandler
{
    NN_DISALLOW_COPY(SuspendHandler);
    NN_DISALLOW_MOVE(SuspendHandler);

public:
    explicit SuspendHandler(nn::ddsf::IDriver* pBaseDriver) NN_NOEXCEPT :
        m_BaseDriver(*pBaseDriver),
        m_GpioBaseAddress(0)
    {
        for ( auto& val : m_EscapedRegisterValue )
        {
            val.Reset();
        }
        for ( auto& val : m_GpioValuesForSleep )
        {
            val.Reset();
        }
    }

    void Initialize(uintptr_t gpioBaseAddress) NN_NOEXCEPT;

    void SetValueForSleepState(PadTegra* pPad, nn::gpio::GpioValue value) NN_NOEXCEPT;

    nn::Result IsWakeEventActive(bool* pOutIsActive, PadTegra* pPad) const NN_NOEXCEPT;
    nn::Result SetWakeEventActiveFlagSetForDebug(PadTegra* pPad, bool enable) NN_NOEXCEPT;
    void SetWakePinDebugMode(nn::gpio::driver::WakePinDebugMode mode) NN_NOEXCEPT;

    void Suspend() NN_NOEXCEPT;
    void SuspendLow() NN_NOEXCEPT;
    void Resume() NN_NOEXCEPT;
    void ResumeLow() NN_NOEXCEPT;

private:
    uintptr_t GetGpioBaseAddress() const NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_EQUAL(m_GpioBaseAddress, 0);
        return m_GpioBaseAddress;
    }

private:
    nn::ddsf::IDriver& m_BaseDriver;
    uintptr_t m_GpioBaseAddress{ 0 };

    // Suspend 時にレジスタの値を保存する配列
    struct RegisterValues
    {
        nn::Bit16  conf;
        nn::Bit8   oe;
        nn::Bit8   out;
        nn::Bit8   intEnb;
        nn::Bit32  intLvl;
        nn::Bit8   dbCtrl;
        nn::Bit8   dbCnt;

        void Reset() NN_NOEXCEPT
        {
            conf = 0;
            oe = 0;
            out = 0;
            intEnb = 0;
            intLvl = 0;
            dbCtrl = 0;
            dbCnt = 0;
        }
    };
    RegisterValues m_EscapedRegisterValue[PadPortCount];

    // Suspend 時の GPIO 出力の設定値を保存しておく配列
    struct GpioValuesForSleepState
    {
        nn::Bit8   IsForceSet;
        nn::Bit8   out;

        void Reset() NN_NOEXCEPT
        {
            IsForceSet = 0;
            out = 0;
        }
    };
    GpioValuesForSleepState m_GpioValuesForSleep[PadPortCount];
};

}}}} // nnd::gpio::tegra::detail
