﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/devicecode/devicecode_Predefined.gpio.h>
#include "gpioTegra_InitialConfig.h"

namespace nnd { namespace gpio { namespace tegra { namespace detail {

static struct GpioInitialConfig initGpioConfigListForIcosa[] =
{
    {
        NN_DEVICECODE_GPIO_NX_RAM_CODE_3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_GAME_CARD_RESET,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_CODEC_ALERT,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_SD_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_GC,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_EXT_CON_WAKE_S,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_GAME_CARD_CD,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_DEBUG_CONTROLLER_DET,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BATT_CHG_STATUS,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BATT_CHG_ENABLE_N,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_FAN_TACH,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_VDD_50_A_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_SDEV_COAX_SEL_1,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PROD_TYPE_0,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PROD_TYPE_1,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PROD_TYPE_2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PROD_TYPE_3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_TEMP_ALERT,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_MOTION_INT,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_CODEC_HP_DET_IRQ,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_TP_IRQ,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_BUTTON_SLEEP_2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_BUTTON_VOL_UP,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_BUTTON_VOL_DN,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_BATT_MGIC_IRQ,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_RECOVERY_KEY,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_LCD_BL_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_LCD_RESET,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_PD_RST_N,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BQ_24190_IRQ,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_SD_CD,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_SDEV_COAX_SEL_0,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_SD_WP,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_CODEC_LDO_EN_TEMP,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_OTG_FET_1_FOR_SDEV,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_TP_RESET,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_EXTCON_DET_U,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_GPIO_2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_GPIO_3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_GPIO_4,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_EXTCON_CHG_U,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_CRADLE_IRQ,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_PD_VCONN_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_VCPU_INT,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_MAX_77621_GPU_INT,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_OTG_FET_2_FOR_SDEV,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_EXTCON_DET_S,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_WIFI_RF_DISABLE,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_WIFI_RESET,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_WIFI_WAKE_HOST,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_AP_WAKE_BT,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_RST,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_WAKE_AP,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_EXT_CON_WAKE_U,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_BT_GPIO_5,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_LCD_VDD_P_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_POW_LCD_VDD_N_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_RAM_CODE_2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        NN_DEVICECODE_GPIO_NX_EXTCON_CHG_S,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        NN_DEVICECODE_GPIO_NX_VDD_50_B_EN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
};

}}}} // nnd::gpio::tegra::detail
