﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       タッチコントローラ ftm4cd60d のデバイス固有の定義です。
 */

#pragma once

#include <nn/i2c/i2c.h>
#include <nnd/ftm/ftm.h>
#include "ftm_Driver.h"
#include "ftm_Driver-4cd60d.updater.h"

namespace nnd { namespace ftm { namespace detail {

// 処理完了待ち時に返ってくると期待するイベントデータ
struct ExpectedEvent
{
    EventId id;
    char value;
};

class Ftm4cd60dController : public IController
{
private:
    Ftm4cd60dUpdater m_Updater;

public:
    Ftm4cd60dController() NN_NOEXCEPT;
    virtual void SetI2cSession(::nn::i2c::I2cSession session) NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ResetDevice() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result BindInterrupt() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ActivateSensing() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result DeactivateSensing() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadLeftEventCount(uint32_t* pOutLeftCount) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadEventReports(char* pOutReadData, uint32_t* pOutReadCount, bool* pOutIsOverflow, uint32_t readCount) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadEventReports(char* pOutReadData, uint32_t* pOutReadCount, uint32_t* pOutLeftCount, bool* pOutIsOverflow, uint32_t readCount) const NN_NOEXCEPT NN_OVERRIDE;
    virtual void ParseEventReports(EventReport* pOutEventReport, const char* pRawData, uint32_t parseCount) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result UpdateFirmware(FirmwareInputFunctionPointer const pFunction, void* const pParameter, size_t fileSize) NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result EraseFirmware() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result RunAutoTune() const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result RunItoTest(ItoEventReport* pOutItoEventReport) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadMutualCompensationData(MutualCompensationData* pOutCompensationData) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadSelfCompensationData(SelfCompensationData* pOutCompensationData) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadMutualRawData(MutualRawData* pOutRawData) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result ReadSelfRawData(SelfRawData* pOutRawData) const NN_NOEXCEPT NN_OVERRIDE;
    virtual ::nn::Result RequestGpioState(GpioInformEventReport* pOutGpioInformEventReport) const NN_NOEXCEPT NN_OVERRIDE;

private:
    ::nn::Result ReadInformation(char* pOutInformation, size_t size) const NN_NOEXCEPT;
    ::nn::Result WaitForCompleteEvent(const ExpectedEvent& expectedData, uint32_t timeoutMilliSeconds, ::nn::Result result) const NN_NOEXCEPT;
    ::nn::Result WaitForCompleteEvent(char* pOutReport, const ExpectedEvent& expectedData, uint32_t timeoutMilliSeconds, ::nn::Result result) const NN_NOEXCEPT;
    ::nn::Result ScreenSenseOn() const NN_NOEXCEPT;
    ::nn::Result FlushBuffer() const NN_NOEXCEPT;
    ::nn::Result ReadInterruptState(bool* pOutIsInterruptEnabled) const NN_NOEXCEPT;
    ::nn::Result EnableInterrupt() const NN_NOEXCEPT;
    ::nn::Result DisableInterrupt() const NN_NOEXCEPT;
    ::nn::Result SwitchSensingMode(SensingMode mode) const NN_NOEXCEPT;
    ::nn::Result RequestMutualCompensationData() const NN_NOEXCEPT;
    ::nn::Result RequestSelfCompensationData() const NN_NOEXCEPT;
    ::nn::Result ReadOffsetForInnerData(uint16_t* pOutOffset, uint8_t offset) const NN_NOEXCEPT;
    ::nn::Result ReadMutualCompensationDataImpl(MutualCompensationData* pOutCompensationData, uint16_t offset) const NN_NOEXCEPT;
    ::nn::Result ReadSelfCompensationDataImpl(SelfCompensationData* pOutCompensationData, uint16_t offset) const NN_NOEXCEPT;
    ::nn::Result ReadMutualRawDataImpl(MutualRawData* pOutRawData, uint16_t offset) const NN_NOEXCEPT;
    ::nn::Result ReadSelfTxRawDataImpl(SelfRawData* pOutRawData, uint16_t offset) const NN_NOEXCEPT;
    ::nn::Result ReadSelfRxRawDataImpl(SelfRawData* pOutRawData, uint16_t offset) const NN_NOEXCEPT;
    ::nn::Result CalibrateLowPowerTimer() const NN_NOEXCEPT;
    ::nn::Result RunMutualAutoTune() const NN_NOEXCEPT;
    ::nn::Result RunSelfAutoTune() const NN_NOEXCEPT;
    ::nn::Result SaveToFlash() const NN_NOEXCEPT;
    EventId ConvertEventValToEnum(uint8_t idVal) const NN_NOEXCEPT;
    EventId ConvertFabEventValToEnum(uint8_t idVal) const NN_NOEXCEPT;
    TouchEventReport ParseTouchContent(const char* pRawData) const NN_NOEXCEPT;
    StatusType ParseStatusContent(const char* pRawData) const NN_NOEXCEPT;
    GpioInformEventReport ParseGpioStateContent(const char* pRawData) const NN_NOEXCEPT;
    ItoEventReport ParseItoErrorContent(const char* pRawData) const NN_NOEXCEPT;
    int32_t ConvertOrientationValToEnum(uint8_t orientationVal) const NN_NOEXCEPT;
    StatusType ConvertStatusValToEnum(uint8_t statusVal) const NN_NOEXCEPT;
    ItoErrorType ConvertItoErrorValToEnum(uint8_t errorTypeVal) const NN_NOEXCEPT;
    bool IsExpectedEvent(const char* pReturnedEvent, const ExpectedEvent& expectedEvent) const NN_NOEXCEPT;
    ::nn::Result ReadEventReportsImpl(char* pOutReadData, uint32_t readCount) const NN_NOEXCEPT;
    ::nn::Result WriteRegister(const void* pInData, size_t dataBytes) const NN_NOEXCEPT;
    ::nn::Result ReadRegister(void* pBuffer, size_t receiveDataBytes, const nn::Bit8* pInData, size_t sendDataBytes) const NN_NOEXCEPT;
};

}}} // namespace nnd::ftm::detail
