﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * バスに関する定義
 */

#include <nn/gpio/gpio.h>
#include <nn/i2c/i2c.h>

namespace nnd {
namespace bh1730fvc {
namespace detail {

const nn::i2c::TransactionOption    I2cTransStop        = nn::i2c::TransactionOption_StopCondition;
const nn::i2c::TransactionOption    I2cTransStart       = nn::i2c::TransactionOption_StartCondition;
const nn::i2c::TransactionOption    I2cTransStartStop   = static_cast<nn::i2c::TransactionOption>(
                                                            nn::i2c::TransactionOption_StartCondition
                                                          | nn::i2c::TransactionOption_StopCondition);

void InitializeBus(nn::i2c::I2cSession* pOutI2cSession) NN_NOEXCEPT;
void FinalizeBus(nn::i2c::I2cSession* pI2cSession) NN_NOEXCEPT;

/**
 * I2C 処理に対するリザルトのハンドリング
 * 直接 i2c を使用する場合に使用。
 */
nn::Result CheckI2cError(nn::Result result) NN_NOEXCEPT;

/**
 * I2C のバス電源を制御する。
 * 将来的には PCV から提供される機能により電源を投入する。
 */
void SetBusPowerEnabled(bool enabled) NN_NOEXCEPT;

} // detail
} // bh1730fvc
} // nnd
