﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * @file
 * @brief       サーマルセンサー TMP451 のシステム開発者向け公開ヘッダです。
 */

/**
 * @namespace   nnd::tmp451
 *
 * @brief       サーマルセンサー TMP451 のドライバライブラリの名前空間です。
 *
 * @detail      本ライブラリの持つ状態は以下のようになります。
 *              未初期化以外の状態を初期化済み状態と呼びます。
 *              @li 未初期化：ライブラリを初期化する前で何れの処理も実行できない状態です。
 *              @li Standby モード：ライブラリが初期化済みで、デバイスの操作が可能な状態です。
 *              @li OneShot モード：温度計測を1回のみ行う状態です。
 *              	計測完了後、自動的に Standby に遷移します。
 *              @li Continuous モード：設定した計測頻度で定期的に温度値の更新が行われる状態です。
 */

#include "tmp451_Api.h"
#include "tmp451_Result.h"
#include "tmp451_Measurement.h"
#include "tmp451_SettingsInterrupt.h"
#include "tmp451_SettingsMeasurment.h"
#include "tmp451_SettingsRemote.h"
#include "tmp451_Types.h"
