﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//--------------------------------------------------------------------------
//  C/C++ 共通の宣言・定義
//--------------------------------------------------------------------------

#include <nnc/nn_Common.h>

#ifdef __cplusplus
extern "C"
{
#endif // ifdef __cplusplus

/**
 * @brief   ポート識別子を表す型です。
 *
 * @see
 *  nn::uart::PortName
 */
typedef enum nnuartPortName
{
    nnuartPortName_Bluetooth = 1,     //!< Bluetooth
    nnuartPortName_ExtConU   = 2,     //!< ExtConU
    nnuartPortName_ExtConS   = 3,     //!< ExtConS
} nnuartPortName;

#ifdef __cplusplus
}
#endif // ifdef __cplusplus
