﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/nn_Result.h>
#include <nnc/nifm/nifm_TypesProxySetting.h>


#ifdef __cplusplus
extern "C"
{
#endif

//! @name 接続情報取得 API（C リンケージ向けインタフェース）
//! @{

/**
 * @brief 現在の接続に利用されているプロキシ設定を取得します。
 *
 * @param[out] pOutProxySetting 取得されるプロキシ設定を格納するバッファへのポインタ
 *
 * @return 処理の結果を表す nnResult 値を返します。
 *
 * @details
 *  現在接続中でない場合は失敗します。失敗時に得られる値は不定です。
 */
nnResult nnnifmGetCurrentProxySetting( nnnifmProxySetting* pOutProxySetting );

//! @}

#ifdef __cplusplus
}
#endif
