﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/nn_Common.h>

//--------------------------------------------------------------------------
//  C/C++ 共通の宣言・定義
//--------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"
{
#endif // ifdef __cplusplus

/**
* @brief GPIO パッドの定義
*
* @details GPIO ライブラリで現在対応している GPIO パッドの一覧です。
*/
typedef enum nngpioGpioPadName
{
    nngpioGpioPadName_AudioPowerEnable       = 1, //!< Audio CODEC Power Enable
    nngpioGpioPadName_EnablePowerToTheSdCard = 2, //!< Enable Power To the SD Card
    nngpioGpioPadName_BluetoothPowerEnable   = 3, //!< Bluetooth Power Enable

} nngpioGpioPadName;

#ifdef __cplusplus
}
#endif // ifdef __cplusplus
