﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nnc/dns/parser/dns_ParserDependencies.h>
#include <nnc/dns/parser/dns_ParserCommon.h>

struct nndnsparserQuestion
{
    const struct nndnsparserMessage* pMessage;
    struct nndnsparserMemoryBlock range;
    size_t dirtySize;
    struct nndnsparserLabel name;
    uint16_t type;
    uint16_t qclass;
};

void nndnsparserQuestionInitialize(struct nndnsparserQuestion* pQuestion,
                                   const struct nndnsparserMessage* pMessage);

ssize_t nndnsparserQuestionSizeOf(const struct nndnsparserQuestion* pQuestion);

bool nndnsparserQuestionIsEqual(const struct nndnsparserQuestion* pQuestion1,
                                const struct nndnsparserQuestion* pQuestion2);

ssize_t nndnsparserQuestionFromBuffer(struct nndnsparserQuestion* pQuestion,
                                      const uint8_t* pBuffer,
                                      size_t size);
ssize_t nndnsparserQuestionToBuffer(uint8_t * const pBuffer,
                                    size_t left,
                                    const struct nndnsparserQuestion* pQuestion);
