﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nnc/dns/parser/dns_ParserDependencies.h>
#include <nnc/dns/parser/dns_ParserCommon.h>

struct nndnsparserMessage
{
    const uint8_t* pBuffer;
    size_t size;
    size_t dirtySize;
    struct nndnsparserMemoryBlock headerSection;
    struct nndnsparserMemoryBlock questionSection;
    struct nndnsparserMemoryBlock answerSection;
    struct nndnsparserMemoryBlock authoritySection;
    struct nndnsparserMemoryBlock additionalSection;
    struct nndnsparserHeader header;
//    struct nndnsparserQuestion question;
};

void nndnsparserMessageInitialize(struct nndnsparserMessage* pMessage);

ssize_t nndnsparserMessageSizeOf(const struct nndnsparserMessage* pMessage);

bool nndnsparserMessageIsEqual(const struct nndnsparserMessage* pMessage1,
                               const struct nndnsparserMessage* pMessage2);

ssize_t nndnsparserMessageFromBuffer(struct nndnsparserMessage* pMessage,
                                     const uint8_t* pBuffer,
                                     size_t size);

ssize_t nndnsparserMessageToBuffer(uint8_t * const pBuffer,
                                   size_t size,
                                   const struct nndnsparserMessage* pMessage);
