﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      wlan モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_WLAN_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_WLAN_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_WLAN_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_WLAN_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_WLAN_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_WLAN_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(wlan, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_WLAN_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Trace, 0, format, args)
#define NN_DETAIL_WLAN_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Trace, 1, format, args)
#define NN_DETAIL_WLAN_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Trace, 2, format, args)
#define NN_DETAIL_WLAN_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Trace, 3, format, args)

#define NN_DETAIL_WLAN_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Info, 0, format, args)
#define NN_DETAIL_WLAN_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Info, 1, format, args)
#define NN_DETAIL_WLAN_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Info, 2, format, args)
#define NN_DETAIL_WLAN_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Info, 3, format, args)

#define NN_DETAIL_WLAN_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Warn, 0, format, args)
#define NN_DETAIL_WLAN_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Warn, 1, format, args)
#define NN_DETAIL_WLAN_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Warn, 2, format, args)
#define NN_DETAIL_WLAN_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Warn, 3, format, args)

#define NN_DETAIL_WLAN_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Error, 0, format, args)
#define NN_DETAIL_WLAN_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Error, 1, format, args)
#define NN_DETAIL_WLAN_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Error, 2, format, args)
#define NN_DETAIL_WLAN_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Error, 3, format, args)

#define NN_DETAIL_WLAN_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Fatal, 0, format, args)
#define NN_DETAIL_WLAN_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Fatal, 1, format, args)
#define NN_DETAIL_WLAN_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Fatal, 2, format, args)
#define NN_DETAIL_WLAN_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(wlan, Fatal, 3, format, args)

#define NN_DETAIL_WLAN_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Trace, 0, text, length)
#define NN_DETAIL_WLAN_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Trace, 1, text, length)
#define NN_DETAIL_WLAN_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Trace, 2, text, length)
#define NN_DETAIL_WLAN_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Trace, 3, text, length)

#define NN_DETAIL_WLAN_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Info, 0, text, length)
#define NN_DETAIL_WLAN_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Info, 1, text, length)
#define NN_DETAIL_WLAN_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Info, 2, text, length)
#define NN_DETAIL_WLAN_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Info, 3, text, length)

#define NN_DETAIL_WLAN_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Warn, 0, text, length)
#define NN_DETAIL_WLAN_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Warn, 1, text, length)
#define NN_DETAIL_WLAN_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Warn, 2, text, length)
#define NN_DETAIL_WLAN_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Warn, 3, text, length)

#define NN_DETAIL_WLAN_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Error, 0, text, length)
#define NN_DETAIL_WLAN_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Error, 1, text, length)
#define NN_DETAIL_WLAN_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Error, 2, text, length)
#define NN_DETAIL_WLAN_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Error, 3, text, length)

#define NN_DETAIL_WLAN_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Fatal, 0, text, length)
#define NN_DETAIL_WLAN_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Fatal, 1, text, length)
#define NN_DETAIL_WLAN_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Fatal, 2, text, length)
#define NN_DETAIL_WLAN_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(wlan, Fatal, 3, text, length)
