﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>
#include <nn/vi/manager/vi_Manager.h>

namespace nn{ namespace vi{ namespace manager{
    class ManagerSharedLayer;

    class ManagerSharedLowLevelLayer
    {
    public:
        ManagerSharedLowLevelLayer() NN_NOEXCEPT;

        // @pre true
        bool IsInitialized() const NN_NOEXCEPT;

        // @pre IsInitialized
        bool IsAttached() const NN_NOEXCEPT;

        // @pre !IsInitialized
        // @post IsInitialized
        void InitializeForDirectLayer(
            DisplayManagerService* pService,
            nn::vi::LayerId layerId,
            const nn::vi::DisplayName& displayName,
            nn::vi::fbshare::SharedBufferHandle hBuffer,
            nn::applet::AppletResourceUserId myAruid
        ) NN_NOEXCEPT;

        // @pre !IsInitialized
        // @post IsInitialized
        void InitializeForIndirectLayer(
            DisplayManagerService* pService,
            nn::vi::IndirectProducerHandleType hProducer,
            nn::vi::fbshare::SharedBufferHandle hBuffer,
            nn::applet::AppletResourceUserId myAruid
        ) NN_NOEXCEPT;

        // @pre IsInitialized
        // @pre !IsInitialized
        void Finalize() NN_NOEXCEPT;

        // @pre IsInitialized
        bool Synchronize(int* pOutDisplayedIndex, nn::TimeSpan timeout) NN_NOEXCEPT;

        // @pre IsInitialized
        // @pre !IsAttached
        void Blank() NN_NOEXCEPT;

        // @pre IsInitialized
        // @pre !IsAttached
        // @post IsAttached
        void Attach(
            ManagerSharedLayer* pLayer,
            const nn::vi::fbshare::SharedLayerTextureIndexList& bufferList
        ) NN_NOEXCEPT;

        // @pre IsInitialized
        // @pre IsAttached
        // @post !IsAttached
        bool Detach(nn::TimeSpan timeout, bool force) NN_NOEXCEPT;

        // @pre IsInitialized
        // @pre IsAttached
        // @post !IsAttached
        void ForceDetach() NN_NOEXCEPT;


    private:
        nn::vi::LayerId GetActiveLayerId() const NN_NOEXCEPT;

        nn::Result InitializeImpl(
            DisplayManagerService* m_pService,
            nn::vi::LayerId layerId,
            nn::vi::fbshare::SharedBufferHandle hBuffer
        ) NN_NOEXCEPT;

    private:
        DisplayManagerService* m_pService;
        nn::applet::AppletResourceUserId m_MyAruid;

        nn::vi::LayerId     m_DirectLayerId;
        nn::vi::DisplayName m_DirectDisplayName;
        nn::vi::IndirectProducerHandleType m_hIndirectProducer;

        nn::vi::fbshare::SharedBufferHandle m_hBuffer;
        ManagerSharedLayer*                 m_pAttachedLayer;

        nn::os::SystemEventType m_SynchronizedEvent;
    };

}}}
