﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Declarations to allow nn::hid to inject hooks into the message procedures.
 * @details This file is not to be distributed in any package and is meant for internal
 *          SDK developers only.
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi/hid/vi_WindowInfo.h>

namespace nn { namespace vi {

    /**
     * @brief Maximum number of windows that may occur on a given platform.
     */
    const int WindowInfoCountMax = 8;

    /**
     * @brief List all windows created by the application through nn::vi.
     *
     * @param[out] pOutWindows    Buffer to write window information.
     * @param[in]  windowCountMax The maximum number of WindowInfo objects that exist in
     *                            the buffer.
     *
     * @return The number of valid WindowInfo objects written to @a pOutWindows.
     *
     * @pre  @a windowCountMax >= 0
     * @post The windows created by the application is written to @a pOutWindows
     *       and the number of windows returned.
     *
     * @details The VI library does not need to be initialized by the application before
     *          calling this function.  In cases where VI is not initialized, this function
     *          will return 0.
     *
     *          The maximum number of windows that may be returned on the current
     *          platform is defined as @ref WindowInfoCountMax.  Please use this constant
     *          for determining the buffer size for @a pOutWindows to avoid dropped results.
     */
    int ListWindows(WindowInfo* pOutWindows, int windowCountMax) NN_NOEXCEPT;

}}
