﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "vi_SharedBufferConfig.h"

namespace nn{ namespace vi{ namespace fbshare{

    class SharedTextureIndexExchangeTable
    {
        static const int WindowTextureCountMax = NativeWindowTextureCountMax;
        static const int BufferTextureCountMax = SharedBufferTextureCountMax;
    public:
        SharedTextureIndexExchangeTable() NN_NOEXCEPT;

        void Reset() NN_NOEXCEPT;
        void Reset(int* pBufferTextureIndexList, int count) NN_NOEXCEPT;

        // @pre windowTextureIndex >= 0
        // iWin -> iBuf
        int ExchangeToBufferTextureIndex(int windowTextureIndex) const NN_NOEXCEPT;

        // @pre bufferTextureIndex >= 0
        // iBuf -> iWin
        int ExchangeToWindowTextureIndex(int bufferTextureIndex) const NN_NOEXCEPT;

    private:
        int m_ToBufferTextureTable[NativeWindowTextureCountMax];
        int m_ToWindowTextureTable[SharedBufferTextureCountMax];
    };

}}}
