﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/vi/native/vi_NativeWindowBuffer.h>

namespace nn{ namespace vi{ namespace fbshare{

    class SharedNativeWindowBuffer
        : private nn::vi::native::NativeWindowBuffer
    {
    public:
        static SharedNativeWindowBuffer* GetSelf(ANativeWindowBuffer* p) NN_NOEXCEPT
        {
            return static_cast<SharedNativeWindowBuffer*>(p);
        }

        SharedNativeWindowBuffer() NN_NOEXCEPT
            : NativeWindowBuffer()
            , m_WindowBufferIndex(-1)
        {
        }

        bool IsEmpty() const NN_NOEXCEPT
        {
            return this->handle == 0;
        }

        void Set(int width, int height, int stride, int format, int usage, buffer_handle_t handle, int windowBufferIndex) NN_NOEXCEPT
        {
            NativeWindowBuffer::Set(width, height, stride, format, usage, handle);
            m_WindowBufferIndex = windowBufferIndex;
        }

        void Clear() NN_NOEXCEPT
        {
            NativeWindowBuffer::Clear();
            m_WindowBufferIndex = -1;
        }

        ANativeWindowBuffer* GetNativeWindowBuffer() NN_NOEXCEPT
        {
            return this;
        }

        int GetWindowBufferIndex() const NN_NOEXCEPT
        {
            return m_WindowBufferIndex;
        }

    private:
        // NVNwindow 内でのインデックス
        int m_WindowBufferIndex;
    };

}}}


