﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_DeviceTypes.h
 * @brief   USB Device Stack Public Data Types
 */

#include <nn/usb/usb_Limits.h>
#include <nn/usb/usb_Types.h>

namespace nn {
namespace usb {

/**
 * @brief Put into the bInterfaceNumber field of the interface descriptor to
 *        ask the device stack to allocate an interface number for you
 */
const uint8_t InterfaceNumberAuto    = DsLimitMaxInterfacesPerConfigurationCount;

/**
 * @brief Put into the bEndpointAddress field of the endpoint descriptor to
 *        ask the device stack to allocate an IN endpoint number for you
 */
const uint8_t EndpointAddressAutoIn  = 0x80;

/**
 * @brief Put into the bEndpointAddress field of the endpoint descriptor to
 *        ask the device stack to allocate an OUT endpoint number for you
 */
const uint8_t EndpointAddressAutoOut = 0x00;

enum UrbStatus
{
    UrbStatus_Invalid,
    UrbStatus_Pending,
    UrbStatus_Running,
    UrbStatus_Finished,
    UrbStatus_Cancelled,
    UrbStatus_Failed,
};

struct UrbReport
{
    struct Report
    {
        uint32_t   id;
        uint32_t   requestedSize;
        uint32_t   transferredSize;
        UrbStatus  status;
    } report[DsLimitRingSize];

    uint32_t count;
};

enum DsString
{
    DsString_Max    = 32,
};

struct DsVidPidBcd
{
    uint16_t    idVendor;
    uint16_t    idProduct;
    uint16_t    bcdDevice;

    char        manufacturer[DsString_Max];
    char        product[DsString_Max];
    char        serialNumber[DsString_Max];
};


} // end of namespace usb
} // end of namespace nn
