﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

/**
 * @file
 * @brief   温度センサーライブラリの初期化と終了処理に関する API の宣言
 */

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/ts/ts_Types.h>
#include <nn/ts/ts_Location.h>

namespace nn {
namespace ts {

//! @name 初期化と終了処理
//! @{

/**
 * @brief       温度センサライブラリを初期化します。
 *
 * @post
 *      初期化済み状態に遷移します。
 *
 * @details
 *      ライブラリを初期化します。@n
 *      本関数の呼び出し回数はライブラリ内部でカウントされます。
 */
void Initialize() NN_NOEXCEPT;


/**
 * @brief       温度センサライブラリの終了処理をします。
 *
 * @pre
 *      初期化済み状態である必要があります。
 *
 * @post
 *      ライブラリ初期化を行った回数分、本関数が呼ばれた場合にのみ、
 *      未初期化状態に遷移します。
 *
 * @details
 *      ライブラリを終了します。
 */
void Finalize() NN_NOEXCEPT;

//! @}

} // ts
} // nn

