﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/time_Common.h>
#include <nn/nn_StaticAssert.h>

#include <algorithm>

namespace nn
{
namespace timesrv
{

// private
const size_t TimesCountMax = 1000;
const size_t TypesCountMax = 128;
const size_t CharsCountMax = 512;

// 1つの時差の情報（特定地域のある時期に適応される時差情報、サマータイムの有無などを保持）. tz database の ttinfo と同等です.
// private
struct TimeTypeInformation
{
    int32_t tt_gmtoff;
    bool   tt_isdst;
    int32_t tt_abbrind;
    bool   tt_ttisstd;
    bool   tt_ttisgmt;
};

// タイムゾーンルール内部実装. tz database の struct state と同等です.
// private
struct TimeZoneRuleInner
{
    int32_t timecnt;
    int32_t typecnt;
    int32_t charcnt;
    bool goback;
    bool goahead;
    int64_t ats[TimesCountMax];
    unsigned char types[TimesCountMax];
    TimeTypeInformation ttis[TypesCountMax];
    char    chars[CharsCountMax];
    int32_t     defaulttype;
};

}
}
