﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/lmem/lmem_ExpHeap.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace util
{

template<size_t Size>
class SfExpHeapAllocator
{
private:
    char m_Buffer[Size];
    nn::sf::ExpHeapAllocator m_ExpHeapAllocator;

public:
    explicit SfExpHeapAllocator(nn::lmem::CreationOption option) NN_NOEXCEPT
    {
        m_ExpHeapAllocator.Attach(nn::lmem::CreateExpHeap(m_Buffer, Size, option));
    }

    nn::sf::ExpHeapAllocator* GetBase() NN_NOEXCEPT
    {
        return &m_ExpHeapAllocator;
    }
};

}
}
}
}
