﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time.h>
#include <nn/time/time_TimeZoneRuleVersion.h>
#include <nn/time/detail/time_CommonDetail.h>

#include <nn/sf/sf_Types.h>
#include <nn/timesrv/detail/service/timesrv_ITimeZoneService.sfdl.h>


namespace nn
{
namespace timesrv
{
namespace detail
{

namespace core
{
    class StandardSteadyClockCore;
    class TimeZoneServiceCore;
}

namespace service
{

class TimeZoneServiceServer
{
private:
    core::StandardSteadyClockCore* m_pStandardSteadyClockCore;
    core::TimeZoneServiceCore* m_pTimeZoneServiceCore;
    bool m_IsAdministrator;

public:
    TimeZoneServiceServer(
        core::StandardSteadyClockCore* pStandardSteadyClockCore,
        core::TimeZoneServiceCore* pTimeZoneServiceCore,
        bool isAdministrator) NN_NOEXCEPT;

    Result GetDeviceLocationName(nn::sf::Out<nn::time::LocationName> outValue) NN_NOEXCEPT;

    Result SetDeviceLocationName(const nn::time::LocationName& value) NN_NOEXCEPT;

    Result GetTotalLocationNameCount(nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    Result LoadTimeZoneRule(
        nn::sf::Out<nn::time::TimeZoneRule> outValue,
        const nn::time::LocationName& locationName) NN_NOEXCEPT;

    Result LoadLocationNameList(
        nn::sf::Out<int32_t> outCount,
        nn::sf::OutArray<nn::time::LocationName> pOutLocationNameList,
        int32_t offset) NN_NOEXCEPT;

    Result GetTimeZoneRuleVersion(nn::sf::Out<nn::time::TimeZoneRuleVersion> outValue) NN_NOEXCEPT;

    Result GetDeviceLocationNameAndUpdatedTime(
        nn::sf::Out<nn::time::LocationName> outLocationName,
        nn::sf::Out<nn::time::SteadyClockTimePoint> outUpdatedTime) NN_NOEXCEPT;

    Result ToCalendarTime(
        nn::sf::Out<nn::time::CalendarTime> outCalendarTime,
        nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo,
        const nn::time::PosixTime& posixTime,
        const nn::time::TimeZoneRule& rule) NN_NOEXCEPT;

    Result ToCalendarTimeWithMyRule(
        nn::sf::Out<nn::time::CalendarTime> outCalendarTime,
        nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo,
        const nn::time::PosixTime& posixTime) NN_NOEXCEPT;

    Result ToPosixTime(
        nn::sf::Out<int32_t> outCount,
        nn::sf::OutArray<nn::time::PosixTime> outPosixTimeList,
        const nn::time::CalendarTime& calendarTime,
        const nn::time::TimeZoneRule& rule) NN_NOEXCEPT;

    Result ToPosixTimeWithMyRule(
        nn::sf::Out<int32_t> outCount,
        nn::sf::OutArray<nn::time::PosixTime> outPosixTimeList,
        const nn::time::CalendarTime& calendarTime) NN_NOEXCEPT;

};

}
}
}
}
