﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/time_Types.h>
#include <nn/time/detail/time_CommonDetail.h>

#include <nn/sf/sf_Types.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{
    class SystemClockCore;
}

namespace service
{

class SystemClockServer
{
private:
    core::SystemClockCore* m_pSystemClockCore;
    const bool m_IsAdministrator;

public:
    SystemClockServer(core::SystemClockCore* pSystemClockCore, bool isAdministrator) NN_NOEXCEPT;

    ~SystemClockServer() NN_NOEXCEPT;

    Result GetCurrentTime(nn::sf::Out<nn::time::PosixTime> outPosixTime) NN_NOEXCEPT;

    Result SetCurrentTime(const nn::time::PosixTime& posixTime) NN_NOEXCEPT;

    Result GetSystemClockContext(nn::sf::Out<nn::time::SystemClockContext> outSystemClockContext) NN_NOEXCEPT;

    Result SetSystemClockContext(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;
};

}
}
}
}
