﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/time_Types.h>
#include <nn/time/detail/time_CommonDetail.h>

// #include <nn/timesrv/detail/service/time_ISteadyClock.sfdl.h>

#include <nn/sf/sf_Types.h>


namespace nn
{
namespace timesrv
{
namespace detail
{

namespace core
{
    class SteadyClockCore;
}

namespace service
{

class SteadyClockServer
{
private:
    core::SteadyClockCore* m_pSteadyClockCore;
    const bool m_IsAdministrator;

public:
    SteadyClockServer(core::SteadyClockCore* pSteadyClockCore, bool isAdministrator) NN_NOEXCEPT;

    ~SteadyClockServer() NN_NOEXCEPT;

    Result GetCurrentTimePoint(nn::sf::Out<nn::time::SteadyClockTimePoint> outSteadyClockTimePoint) NN_NOEXCEPT;

    Result GetTestOffset(nn::sf::Out<nn::TimeSpanType> outTestOffset) NN_NOEXCEPT;

    Result SetTestOffset(const nn::TimeSpanType& testOffset) NN_NOEXCEPT;

    Result GetRtcValue(nn::sf::Out<int64_t> outValue) NN_NOEXCEPT;

    Result IsRtcResetDetected(nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    Result GetSetupResutltValue(nn::sf::Out<uint32_t> outValue) NN_NOEXCEPT;

    Result GetInternalOffset(nn::sf::Out<nn::TimeSpanType> outInternalOffset) NN_NOEXCEPT;

};

}
}
}
}
