﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <nn/nn_Result.h>
#include <nn/time/time_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace timesrv { namespace detail { namespace service { // NOLINT(whitespace/braces)

class ISystemClock;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemClock, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemClock)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentTime, (::nn::sf::Out<::nn::time::PosixTime> outPosixTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentTime, (::nn::time::PosixTime posixTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemClockContext, (::nn::sf::Out<::nn::time::SystemClockContext> outSystemClockContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemClockContext, (const ::nn::time::SystemClockContext& systemClockContext))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemClock)

        ::nn::Result GetCurrentTime(::nn::sf::Out<::nn::time::PosixTime> outPosixTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCurrentTime, (outPosixTime));
        }

        ::nn::Result SetCurrentTime(::nn::time::PosixTime posixTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetCurrentTime, (posixTime));
        }

        ::nn::Result GetSystemClockContext(::nn::sf::Out<::nn::time::SystemClockContext> outSystemClockContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemClockContext, (outSystemClockContext));
        }

        ::nn::Result SetSystemClockContext(const ::nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSystemClockContext, (systemClockContext));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemClock
    {
    public:
        nn::Result GetCurrentTime(nn::sf::Out<nn::time::PosixTime> outPosixTime) NN_NOEXCEPT;
        nn::Result SetCurrentTime(nn::time::PosixTime posixTime) NN_NOEXCEPT;
        nn::Result GetSystemClockContext(nn::sf::Out<nn::time::SystemClockContext> outSystemClockContext) NN_NOEXCEPT;
        nn::Result SetSystemClockContext(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetCurrentTime(nn::sf::Out<nn::time::PosixTime> outPosixTime) NN_NOEXCEPT;
    nn::Result SetCurrentTime(nn::time::PosixTime posixTime) NN_NOEXCEPT;
    nn::Result GetSystemClockContext(nn::sf::Out<nn::time::SystemClockContext> outSystemClockContext) NN_NOEXCEPT;
    nn::Result SetSystemClockContext(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::timesrv::detail::service::ISystemClock))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentTime, (::nn::sf::Out<::nn::time::PosixTime> outPosixTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCurrentTime, (outPosixTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentTime, (::nn::time::PosixTime posixTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetCurrentTime, (posixTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemClockContext, (::nn::sf::Out<::nn::time::SystemClockContext> outSystemClockContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemClockContext, (outSystemClockContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemClockContext, (const ::nn::time::SystemClockContext& systemClockContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSystemClockContext, (systemClockContext));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::timesrv::detail::service::ISystemClock>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::timesrv::detail::service::ISystemClock))

    // nn::Result GetCurrentTime(nn::sf::Out<nn::time::PosixTime> outPosixTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCurrentTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outPosixTime, (::nn::time::PosixTime), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outPosixTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPosixTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCurrentTime)

    // nn::Result SetCurrentTime(nn::time::PosixTime posixTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCurrentTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(posixTime, (::nn::time::PosixTime), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (posixTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(posixTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCurrentTime)

    // nn::Result GetSystemClockContext(nn::sf::Out<nn::time::SystemClockContext> outSystemClockContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemClockContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSystemClockContext, (::nn::time::SystemClockContext), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSystemClockContext))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSystemClockContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemClockContext)

    // nn::Result SetSystemClockContext(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSystemClockContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(systemClockContext, (::nn::time::SystemClockContext), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (systemClockContext))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(systemClockContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSystemClockContext)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::PosixTime), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::SystemClockContext), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::timesrv::detail::service::ISystemClock, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::timesrv::detail::service::ISystemClock))

    // nn::Result GetCurrentTime(nn::sf::Out<nn::time::PosixTime> outPosixTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCurrentTime, (::nn::sf::Out<::nn::time::PosixTime> outPosixTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCurrentTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPosixTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCurrentTime)
    }

    // nn::Result SetCurrentTime(nn::time::PosixTime posixTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCurrentTime, (::nn::time::PosixTime posixTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCurrentTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(posixTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCurrentTime)
    }

    // nn::Result GetSystemClockContext(nn::sf::Out<nn::time::SystemClockContext> outSystemClockContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemClockContext, (::nn::sf::Out<::nn::time::SystemClockContext> outSystemClockContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemClockContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSystemClockContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemClockContext)
    }

    // nn::Result SetSystemClockContext(const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemClockContext, (const ::nn::time::SystemClockContext& systemClockContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSystemClockContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(systemClockContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSystemClockContext)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::timesrv::detail::service::ISystemClock>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::timesrv::detail::service::ISystemClock))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCurrentTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCurrentTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outPosixTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCurrentTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCurrentTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(posixTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemClockContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemClockContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSystemClockContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSystemClockContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSystemClockContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(systemClockContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCurrentTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCurrentTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemClockContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSystemClockContext)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::timesrv::detail::service::ISystemClock))
