﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/time/time_LocationName.h>
#include <nn/timesrv/detail/fs/timesrv_BinaryPath.h>

namespace nn { namespace timesrv { namespace detail { namespace fs {

    /**
     * @brief   Time で使用するファイルシステムのマウント
     */
    nn::Result Mount() NN_NOEXCEPT;

    /**
     * @brief   バイナリのパスの取得
     * @param[out]  pOut    バイナリパス
     * @param[in]   name    タイムゾーン名
     *
     * @pre
     *  - pOut != nullptr
     *
     * @details
     *  - 指定のタイムゾーン名のバイナリが存在するかどうかはチェックしません。
     */
    void GetFilePath(BinaryPath* pOut, const nn::time::LocationName& name) NN_NOEXCEPT;

    /**
     * @brief   地域名の一覧データのパスの取得
     * @param[out]  pOut    バイナリパス
     *
     * @pre
     *  - pOut != nullptr
     */
    void GetFilePathOfTimeZoneListData(BinaryPath* pOut) NN_NOEXCEPT;

    /**
     * @brief   タイムゾーンバージョンのファイルパス取得
     * @param[out]  pOut    パス
     *
     * @pre
     *  - pOut != nullptr
     */
    void GetFilePathOfTimeZoneVersion(BinaryPath* pOut) NN_NOEXCEPT;

    /**
     * @brief   バイナリサイズの取得
     * @param[out]  pOut    バイナリサイズ
     * @param[in]   path    バイナリパス
     *
     * @return  処理結果
     * @retval  ResultSuccess   成功
     * @retval  その他           nn::fs の Result を返すことがあります
     *
     * @pre
     *  - pOut != nullptr
     *
     * @details
     */
    nn::Result GetFileSize(size_t *pOut, const BinaryPath &path) NN_NOEXCEPT;

    /**
     * @brief       バイナリロード
     * @param[out]  pOutSize    ロードしたサイズ
     * @param[out]  pOutBuffer  ロードするバッファ
     * @param[in]   size        pOut のサイズ
     * @param[in]   path        バイナリパス
     *
     * @return  処理結果
     * @retval  ResultSuccess       成功
     * @retval  ResultOutOfMemory   pOut のサイズ不足
     * @retval  その他              nn::fs の Result を返すことがあります
     *
     * @pre
     *  - pOut != nullptr
     *
     * @details
     */
    nn::Result ReadFile(size_t* pOutSize, char* pOutBuffer, size_t size, const BinaryPath &path) NN_NOEXCEPT;

}}}} // nn::timesrv::detail::fs
