﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 温度制御モジュールの API 宣言。
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/os.h>

#include "tc_Types.h"

namespace nn { namespace tc {

//! @name 動作モード関連 API
//! @{

/**
 * @brief       温度制御モジュールに現在の動作モードを設定します。
 *
 * @param[in]   operatingMode 動作モードを表す @ref nn::tc::OperatingMode 型の列挙値です。
 *
 * @return      処理の結果を返します。
 *
 * @post        温度制御モジュールが所持する目標温度と温度制御ポリシーが動作モードに応じて変更されます。
 *
 * @details     温度調整モジュールに動作モードに対応する目標温度と温度制御ポリシーを設定します。
 */
nn::Result SetOperatingMode(OperatingMode operatingMode) NN_NOEXCEPT;

//! @}

}} // namepsace nn::tc
