﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace stdfu {

struct UpdateStatus
{
    uint32_t    phase;
    uint32_t    image;
    uint32_t    element;
    uint32_t    progress;
};

enum UpdatePhase
{
    UpdatePhase_None = 0,
    UpdatePhase_Address,
    UpdatePhase_Write,
    UpdatePhase_Verify,
};

class DfuUpdateStatus
{
public:

    DfuUpdateStatus() NN_NOEXCEPT;
    ~DfuUpdateStatus() NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    void SetPhase(uint32_t phase) NN_NOEXCEPT;
    void SetImage(uint32_t image)  NN_NOEXCEPT;
    void SetElement(uint32_t element)  NN_NOEXCEPT;
    void SetProgress(uint32_t progress)  NN_NOEXCEPT;

    void GetUpdateStatus(UpdateStatus *pUpdateStatus)  NN_NOEXCEPT;

private:

    nn::os::Mutex   m_Mutex;
    UpdateStatus    m_UpdateStatus;
};


} // namespace stdfu
} // namespace nn
