﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/ssl/detail/ssl_ISslConnection.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ssl { namespace sf { // NOLINT(whitespace/braces)

struct CertificateFormat;

struct ContextOption;

struct InternalPki;

class ISslContext;

struct SslVersion;

struct CertificateFormat
{
    std::uint32_t value;
};

struct ContextOption
{
    std::uint32_t name;
};

struct InternalPki
{
    std::int32_t pki;
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISslContext, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISslContext)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetOption, (::nn::ssl::sf::ContextOption option, ::std::int32_t value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetOption, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ssl::sf::ContextOption option))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateConnection, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ssl::sf::ISslConnection>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionCount, (::nn::sf::Out<::std::uint32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ImportServerPki, (::nn::sf::Out<::std::uint64_t> outCertId, const ::nn::sf::InBuffer& inCertData, ::nn::ssl::sf::CertificateFormat format))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ImportClientPki, (::nn::sf::Out<::std::uint64_t> outCertId, const ::nn::sf::InBuffer& inP12Data, const ::nn::sf::InBuffer& inPwData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RemoveServerPki, (::std::uint64_t certId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RemoveClientPki, (::std::uint64_t certId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterInternalPki, (::nn::sf::Out<::std::uint64_t> outCertId, ::nn::ssl::sf::InternalPki pkiType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddPolicyOid, (const ::nn::sf::InBuffer& stringBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ImportCrl, (::nn::sf::Out<::std::uint64_t> outCrlId, const ::nn::sf::InBuffer& inCrlDerData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RemoveCrl, (::std::uint64_t crlId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISslContext)

        ::nn::Result SetOption(::nn::ssl::sf::ContextOption option, ::std::int32_t value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetOption, (option, value));
        }

        ::nn::Result GetOption(::nn::sf::Out<::std::int32_t> outValue, ::nn::ssl::sf::ContextOption option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetOption, (outValue, option));
        }

        ::nn::Result CreateConnection(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ssl::sf::ISslConnection>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateConnection, (outValue));
        }

        ::nn::Result GetConnectionCount(::nn::sf::Out<::std::uint32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetConnectionCount, (outValue));
        }

        ::nn::Result ImportServerPki(::nn::sf::Out<::std::uint64_t> outCertId, const ::nn::sf::InBuffer& inCertData, ::nn::ssl::sf::CertificateFormat format) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ImportServerPki, (outCertId, inCertData, format));
        }

        ::nn::Result ImportClientPki(::nn::sf::Out<::std::uint64_t> outCertId, const ::nn::sf::InBuffer& inP12Data, const ::nn::sf::InBuffer& inPwData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ImportClientPki, (outCertId, inP12Data, inPwData));
        }

        ::nn::Result RemoveServerPki(::std::uint64_t certId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RemoveServerPki, (certId));
        }

        ::nn::Result RemoveClientPki(::std::uint64_t certId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RemoveClientPki, (certId));
        }

        ::nn::Result RegisterInternalPki(::nn::sf::Out<::std::uint64_t> outCertId, ::nn::ssl::sf::InternalPki pkiType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterInternalPki, (outCertId, pkiType));
        }

        ::nn::Result AddPolicyOid(const ::nn::sf::InBuffer& stringBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddPolicyOid, (stringBuffer));
        }

        ::nn::Result ImportCrl(::nn::sf::Out<::std::uint64_t> outCrlId, const ::nn::sf::InBuffer& inCrlDerData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ImportCrl, (outCrlId, inCrlDerData));
        }

        ::nn::Result RemoveCrl(::std::uint64_t crlId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RemoveCrl, (crlId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISslContext
    {
    public:
        nn::Result SetOption(nn::ssl::sf::ContextOption option, std::int32_t value) NN_NOEXCEPT;
        nn::Result GetOption(nn::sf::Out<std::int32_t> outValue, nn::ssl::sf::ContextOption option) NN_NOEXCEPT;
        nn::Result CreateConnection(nn::sf::Out<nn::sf::SharedPointer<nn::ssl::sf::ISslConnection>> outValue) NN_NOEXCEPT;
        nn::Result GetConnectionCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
        nn::Result ImportServerPki(nn::sf::Out<std::uint64_t> outCertId, const nn::sf::InBuffer& inCertData, nn::ssl::sf::CertificateFormat format) NN_NOEXCEPT;
        nn::Result ImportClientPki(nn::sf::Out<std::uint64_t> outCertId, const nn::sf::InBuffer& inP12Data, const nn::sf::InBuffer& inPwData) NN_NOEXCEPT;
        nn::Result RemoveServerPki(std::uint64_t certId) NN_NOEXCEPT;
        nn::Result RemoveClientPki(std::uint64_t certId) NN_NOEXCEPT;
        nn::Result RegisterInternalPki(nn::sf::Out<std::uint64_t> outCertId, nn::ssl::sf::InternalPki pkiType) NN_NOEXCEPT;
        nn::Result AddPolicyOid(const nn::sf::InBuffer& stringBuffer) NN_NOEXCEPT;
        nn::Result ImportCrl(nn::sf::Out<std::uint64_t> outCrlId, const nn::sf::InBuffer& inCrlDerData) NN_NOEXCEPT;
        nn::Result RemoveCrl(std::uint64_t crlId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetOption(nn::ssl::sf::ContextOption option, std::int32_t value) NN_NOEXCEPT;
    nn::Result GetOption(nn::sf::Out<std::int32_t> outValue, nn::ssl::sf::ContextOption option) NN_NOEXCEPT;
    nn::Result CreateConnection(nn::sf::Out<nn::sf::SharedPointer<nn::ssl::sf::ISslConnection>> outValue) NN_NOEXCEPT;
    nn::Result GetConnectionCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT;
    nn::Result ImportServerPki(nn::sf::Out<std::uint64_t> outCertId, const nn::sf::InBuffer& inCertData, nn::ssl::sf::CertificateFormat format) NN_NOEXCEPT;
    nn::Result ImportClientPki(nn::sf::Out<std::uint64_t> outCertId, const nn::sf::InBuffer& inP12Data, const nn::sf::InBuffer& inPwData) NN_NOEXCEPT;
    nn::Result RemoveServerPki(std::uint64_t certId) NN_NOEXCEPT;
    nn::Result RemoveClientPki(std::uint64_t certId) NN_NOEXCEPT;
    nn::Result RegisterInternalPki(nn::sf::Out<std::uint64_t> outCertId, nn::ssl::sf::InternalPki pkiType) NN_NOEXCEPT;
    nn::Result AddPolicyOid(const nn::sf::InBuffer& stringBuffer) NN_NOEXCEPT;
    nn::Result ImportCrl(nn::sf::Out<std::uint64_t> outCrlId, const nn::sf::InBuffer& inCrlDerData) NN_NOEXCEPT;
    nn::Result RemoveCrl(std::uint64_t crlId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ssl::sf::ISslContext))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOption, (::nn::ssl::sf::ContextOption option, ::std::int32_t value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetOption, (option, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOption, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ssl::sf::ContextOption option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetOption, (outValue, option));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateConnection, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ssl::sf::ISslConnection>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateConnection, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionCount, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetConnectionCount, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportServerPki, (::nn::sf::Out<::std::uint64_t> outCertId, const ::nn::sf::InBuffer& inCertData, ::nn::ssl::sf::CertificateFormat format))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ImportServerPki, (outCertId, inCertData, format));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportClientPki, (::nn::sf::Out<::std::uint64_t> outCertId, const ::nn::sf::InBuffer& inP12Data, const ::nn::sf::InBuffer& inPwData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ImportClientPki, (outCertId, inP12Data, inPwData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveServerPki, (::std::uint64_t certId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RemoveServerPki, (certId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveClientPki, (::std::uint64_t certId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RemoveClientPki, (certId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterInternalPki, (::nn::sf::Out<::std::uint64_t> outCertId, ::nn::ssl::sf::InternalPki pkiType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterInternalPki, (outCertId, pkiType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddPolicyOid, (const ::nn::sf::InBuffer& stringBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddPolicyOid, (stringBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportCrl, (::nn::sf::Out<::std::uint64_t> outCrlId, const ::nn::sf::InBuffer& inCrlDerData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ImportCrl, (outCrlId, inCrlDerData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveCrl, (::std::uint64_t crlId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RemoveCrl, (crlId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ssl::sf::ISslContext>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ssl::sf::ISslContext))

    // nn::Result SetOption(nn::ssl::sf::ContextOption option, std::int32_t value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetOption)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::ssl::sf::ContextOption), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (option, value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetOption)

    // nn::Result GetOption(nn::sf::Out<std::int32_t> outValue, nn::ssl::sf::ContextOption option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetOption)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::nn::ssl::sf::ContextOption), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (option))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetOption)

    // nn::Result CreateConnection(nn::sf::Out<nn::sf::SharedPointer<nn::ssl::sf::ISslConnection>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateConnection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateConnection)

    // nn::Result GetConnectionCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetConnectionCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetConnectionCount)

    // nn::Result ImportServerPki(nn::sf::Out<std::uint64_t> outCertId, const nn::sf::InBuffer& inCertData, nn::ssl::sf::CertificateFormat format) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ImportServerPki)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inCertData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inCertData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(format, (::nn::ssl::sf::CertificateFormat), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (format))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCertId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCertId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCertId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inCertData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(format)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ImportServerPki)

    // nn::Result ImportClientPki(nn::sf::Out<std::uint64_t> outCertId, const nn::sf::InBuffer& inP12Data, const nn::sf::InBuffer& inPwData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ImportClientPki)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inP12Data, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inPwData, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inP12Data, inPwData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCertId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCertId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCertId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inP12Data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inPwData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ImportClientPki)

    // nn::Result RemoveServerPki(std::uint64_t certId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveServerPki)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(certId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (certId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(certId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveServerPki)

    // nn::Result RemoveClientPki(std::uint64_t certId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveClientPki)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(certId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (certId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(certId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveClientPki)

    // nn::Result RegisterInternalPki(nn::sf::Out<std::uint64_t> outCertId, nn::ssl::sf::InternalPki pkiType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterInternalPki)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pkiType, (::nn::ssl::sf::InternalPki), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pkiType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCertId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCertId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCertId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pkiType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterInternalPki)

    // nn::Result AddPolicyOid(const nn::sf::InBuffer& stringBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddPolicyOid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(stringBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (stringBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stringBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddPolicyOid)

    // nn::Result ImportCrl(nn::sf::Out<std::uint64_t> outCrlId, const nn::sf::InBuffer& inCrlDerData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ImportCrl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inCrlDerData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inCrlDerData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCrlId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCrlId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCrlId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inCrlDerData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ImportCrl)

    // nn::Result RemoveCrl(std::uint64_t crlId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveCrl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(crlId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (crlId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(crlId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveCrl)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ssl::sf::ISslContext, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ssl::sf::ISslContext))

    // nn::Result SetOption(nn::ssl::sf::ContextOption option, std::int32_t value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetOption, (::nn::ssl::sf::ContextOption option, ::std::int32_t value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetOption)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetOption)
    }

    // nn::Result GetOption(nn::sf::Out<std::int32_t> outValue, nn::ssl::sf::ContextOption option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOption, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ssl::sf::ContextOption option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetOption)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetOption)
    }

    // nn::Result CreateConnection(nn::sf::Out<nn::sf::SharedPointer<nn::ssl::sf::ISslConnection>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateConnection, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ssl::sf::ISslConnection>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateConnection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateConnection)
    }

    // nn::Result GetConnectionCount(nn::sf::Out<std::uint32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionCount, (::nn::sf::Out<::std::uint32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetConnectionCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetConnectionCount)
    }

    // nn::Result ImportServerPki(nn::sf::Out<std::uint64_t> outCertId, const nn::sf::InBuffer& inCertData, nn::ssl::sf::CertificateFormat format) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportServerPki, (::nn::sf::Out<::std::uint64_t> outCertId, const ::nn::sf::InBuffer& inCertData, ::nn::ssl::sf::CertificateFormat format))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ImportServerPki)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCertId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inCertData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(format)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ImportServerPki)
    }

    // nn::Result ImportClientPki(nn::sf::Out<std::uint64_t> outCertId, const nn::sf::InBuffer& inP12Data, const nn::sf::InBuffer& inPwData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportClientPki, (::nn::sf::Out<::std::uint64_t> outCertId, const ::nn::sf::InBuffer& inP12Data, const ::nn::sf::InBuffer& inPwData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ImportClientPki)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCertId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inP12Data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inPwData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ImportClientPki)
    }

    // nn::Result RemoveServerPki(std::uint64_t certId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveServerPki, (::std::uint64_t certId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveServerPki)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(certId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveServerPki)
    }

    // nn::Result RemoveClientPki(std::uint64_t certId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveClientPki, (::std::uint64_t certId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveClientPki)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(certId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveClientPki)
    }

    // nn::Result RegisterInternalPki(nn::sf::Out<std::uint64_t> outCertId, nn::ssl::sf::InternalPki pkiType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterInternalPki, (::nn::sf::Out<::std::uint64_t> outCertId, ::nn::ssl::sf::InternalPki pkiType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterInternalPki)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCertId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pkiType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterInternalPki)
    }

    // nn::Result AddPolicyOid(const nn::sf::InBuffer& stringBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddPolicyOid, (const ::nn::sf::InBuffer& stringBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddPolicyOid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stringBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddPolicyOid)
    }

    // nn::Result ImportCrl(nn::sf::Out<std::uint64_t> outCrlId, const nn::sf::InBuffer& inCrlDerData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ImportCrl, (::nn::sf::Out<::std::uint64_t> outCrlId, const ::nn::sf::InBuffer& inCrlDerData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ImportCrl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCrlId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inCrlDerData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ImportCrl)
    }

    // nn::Result RemoveCrl(std::uint64_t crlId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveCrl, (::std::uint64_t crlId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveCrl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(crlId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveCrl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ssl::sf::ISslContext>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ssl::sf::ISslContext))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetOption)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetOption)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateConnection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ssl::sf::ISslConnection>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateConnection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetConnectionCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetConnectionCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ImportServerPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inCertData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ImportServerPki)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCertId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inCertData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(format)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ImportClientPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inP12Data)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inPwData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ImportClientPki)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCertId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inP12Data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inPwData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveServerPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveServerPki)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(certId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveClientPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveClientPki)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(certId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterInternalPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterInternalPki)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCertId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pkiType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddPolicyOid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(stringBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddPolicyOid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(stringBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ImportCrl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inCrlDerData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ImportCrl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCrlId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inCrlDerData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveCrl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveCrl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(crlId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetOption)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateConnection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetConnectionCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ImportServerPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ImportClientPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveServerPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveClientPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterInternalPki)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddPolicyOid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ImportCrl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveCrl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ssl::sf::ISslContext))

namespace nn { namespace ssl { namespace sf { // NOLINT(whitespace/braces)

struct SslVersion
{
    std::int32_t flags;
};

}}}
