﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn { namespace srepo {

/*!
    @brief  受理されたネットワーク利用要求の種類を表す列挙型です。
*/
enum class CompletedNetworkRequestType : int8_t
{
    None,                   //!< 受理されたネットワーク利用要求がない
    WideAreaNetwork,        //!< 外部への通信要求を伴う利用要求が受理された
    LocalAreaNetwork,       //!< LAN内での通信(APまでの通信)要求が受理された
    LocalDirectNetwork,     //!< デバイス同士の直接通信(ローカル通信)要求が受理された
    NeighborDetection,      //!< すれちがい通信要求が受理された
};

/*!
    @brief  フレンドプレゼンスを表す列挙型です。
*/
enum class FriendPresence : int8_t
{
    Offline,    //!< オフライン
    Online,     //!< オンライン
    OnlinePlay, //!< オンラインプレイ
};

/*!
    @brief  通知モジュールの接続性を表す列挙型です。
*/
enum class NotificationConnectivity : int8_t
{
    Available,      //!< 利用可
    Unavailable,    //!< 利用不可
};

/*!
    @brief  本体の動作モードを表す列挙型です。

    @details
        システム起動後速やかに最新状態を設定してください。
*/
enum class DeviceOperationMode : int8_t
{
    Handheld,   //!< 手持ち
    Console,    //!< 据え置き
    Unknown,    //!< 不明
};

/*!
    @brief  システムのパワーステートを表す列挙型です。
*/
enum class SystemPowerState : int8_t
{
    FullAwake,                      //!< システムが全て稼働している状態
    MinimumAwake,                   //!< システムの必要最小限の機能が稼働している状態
    MinimumAwakeForLowBatterySign,  //!< 要充電画面を表示している状態
    MinimumAwakeForBackgroundTask,  //!< バックグラウンドタスクを実行している状態
    SleepReady,                     //!< システムをスリープする準備が完了した状態、またはスリープから起床した直後の状態
    ShutdownReady,                  //!< システムをシャットダウン・または再起動する準備が完了した状態
};

}}
