﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/srepo/srepo_TypesAdmin.h>

namespace nn { namespace srepo {

//! @name アカウントモジュール向け
//! @{

/*!
    @brief  ユーザーリストを通知します。
*/
void NotifyUserList(const nn::account::Uid users[], int count) NN_NOEXCEPT;
/*!
    @brief  ユーザーの削除を通知します。
*/
void NotifyUserDeleted(const nn::account::Uid& uid) NN_NOEXCEPT;
/*!
    @brief  ユーザーの登録を通知します。
*/
void NotifyUserRegistered(const nn::account::Uid& uid) NN_NOEXCEPT;
/*!
    @brief  ユーザーのクローズを通知します。
*/
void NotifyUserClosed(const nn::account::Uid& uid) NN_NOEXCEPT;
/*!
    @brief  ユーザーのオープンを通知します。
*/
void NotifyUserOpened(const nn::account::Uid& uid) NN_NOEXCEPT;

//! @}


//! @name ネットワーク利用要求管理モジュール向けAPI
//! @{

/*!
    @brief  受理されたネットワーク利用要求の変化を通知します。

    @param[in] type     リクエストタイプ

    @details
        本関数を呼び出す前の初期値は CompletedNetworkRequestType::None です。
*/
void NotifyCompletedNetworkRequestChanged(CompletedNetworkRequestType type) NN_NOEXCEPT;

//! @}


//! @name フレンドプレゼンス管理モジュール向けAPI
//! @{

/*!
    @brief  フレンドプレゼンスの変更を通知します。

    @param[in] uid      ユーザ
    @param[in] state    状態

    details
        本関数を呼び出す前の初期値は Offline です。
*/
void NotifyFriendPresenceChanged(const nn::account::Uid& uid, FriendPresence state) NN_NOEXCEPT;

//! @}


//! @name 通知管理モジュール向けAPI
//! @{

/*!
    @brief  通知モジュールの接続性変更を通知します。

    @param[in] state 状態

    @details
        本関数を呼び出す前の初期値は Unavailable です。
*/
void NotifyNotificationConnectivityChanged(NotificationConnectivity state) NN_NOEXCEPT;

//! @}


//! @name 本体の動作モード管理モジュール向けAPI
//! @{

/*!
    @brief  本体の動作モードの変更を通知します。

    @param[in] mode モード

    @pre
        - mode != DeviceOperationMode::Unknown

    @details
        システム起動後速やかに最新状態を設定してください。
*/
void NotifyDeviceOperationModeChanged(DeviceOperationMode mode) NN_NOEXCEPT;

//! @}


//! @name システムのパワーステート管理モジュール向けAPI
//! @{

/*!
    @brief  システムのパワーステートの変更を通知します。

    @param[in] state 状態

    @details
        システム起動後速やかに最新状態を設定してください。
*/
void NotifySystemPowerStateChanged(SystemPowerState state) NN_NOEXCEPT;

//! @}


//! @name 起動プログラム管理モジュール向けAPI
//! @{

/*!
    @brief  フォアグラウンドプログラムの変更を通知します。

    @param[in] id プログラムID

    @details
        システム起動後速やかに最新状態を設定してください。
*/
void NotifyForegroundProgramChanged(const nn::ncm::ProgramId& id) NN_NOEXCEPT;

//! @}


//! @name コントローラ管理モジュール向けAPI
//! @{

/*!
    @brief  コントローラの接続数変更を通知します。

    @param[in] total    接続されているコントローラの総数
    @param[in] rail     レール接続されたコントローラ数

    @pre
        - total >= 0
        - rail >= 0
        - total >= rail

    @details
        本関数を呼び出す前の初期値は total, rail 共に 0 です。
*/
void NotifyControllerCountChanged(int8_t total, int8_t rail) NN_NOEXCEPT;

//! @}

}}
