﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      srepo モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_SREPO_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_SREPO_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_SREPO_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_SREPO_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_SREPO_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_SREPO_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(srepo, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_SREPO_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Trace, 0, format, args)
#define NN_DETAIL_SREPO_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Trace, 1, format, args)
#define NN_DETAIL_SREPO_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Trace, 2, format, args)
#define NN_DETAIL_SREPO_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Trace, 3, format, args)

#define NN_DETAIL_SREPO_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Info, 0, format, args)
#define NN_DETAIL_SREPO_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Info, 1, format, args)
#define NN_DETAIL_SREPO_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Info, 2, format, args)
#define NN_DETAIL_SREPO_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Info, 3, format, args)

#define NN_DETAIL_SREPO_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Warn, 0, format, args)
#define NN_DETAIL_SREPO_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Warn, 1, format, args)
#define NN_DETAIL_SREPO_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Warn, 2, format, args)
#define NN_DETAIL_SREPO_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Warn, 3, format, args)

#define NN_DETAIL_SREPO_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Error, 0, format, args)
#define NN_DETAIL_SREPO_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Error, 1, format, args)
#define NN_DETAIL_SREPO_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Error, 2, format, args)
#define NN_DETAIL_SREPO_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Error, 3, format, args)

#define NN_DETAIL_SREPO_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Fatal, 0, format, args)
#define NN_DETAIL_SREPO_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Fatal, 1, format, args)
#define NN_DETAIL_SREPO_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Fatal, 2, format, args)
#define NN_DETAIL_SREPO_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(srepo, Fatal, 3, format, args)

#define NN_DETAIL_SREPO_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Trace, 0, text, length)
#define NN_DETAIL_SREPO_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Trace, 1, text, length)
#define NN_DETAIL_SREPO_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Trace, 2, text, length)
#define NN_DETAIL_SREPO_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Trace, 3, text, length)

#define NN_DETAIL_SREPO_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Info, 0, text, length)
#define NN_DETAIL_SREPO_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Info, 1, text, length)
#define NN_DETAIL_SREPO_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Info, 2, text, length)
#define NN_DETAIL_SREPO_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Info, 3, text, length)

#define NN_DETAIL_SREPO_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Warn, 0, text, length)
#define NN_DETAIL_SREPO_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Warn, 1, text, length)
#define NN_DETAIL_SREPO_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Warn, 2, text, length)
#define NN_DETAIL_SREPO_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Warn, 3, text, length)

#define NN_DETAIL_SREPO_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Error, 0, text, length)
#define NN_DETAIL_SREPO_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Error, 1, text, length)
#define NN_DETAIL_SREPO_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Error, 2, text, length)
#define NN_DETAIL_SREPO_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Error, 3, text, length)

#define NN_DETAIL_SREPO_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Fatal, 0, text, length)
#define NN_DETAIL_SREPO_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Fatal, 1, text, length)
#define NN_DETAIL_SREPO_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Fatal, 2, text, length)
#define NN_DETAIL_SREPO_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(srepo, Fatal, 3, text, length)
