﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/srepo/detail/service/srepo_Common.h>
#include <nn/srepo/detail/service/core/srepo_SomeValue.h>

namespace nn { namespace srepo { namespace detail { namespace service { namespace core {

/*!
    @brief   ステートが変化した時点を扱う型です。
*/
struct StateChangePoint
{
    SomeValueBase* pStateValue; //!< ステート値のポインタ
    nn::TimeSpanType time;  //!< stateに切り替わったタイミング
};

/*!
    @brief   ステートの継続時間を扱う型です。
*/
struct StateDuration
{
    const SomeValueBase* pStateValue; //!< ステート値のポインタ
    nn::TimeSpanType duration; //!< 継続時間
};

/*!
    @brief  StateDurationを生成します。

    @param[out] pOut        出力先を指定します。
    @param[in]  changePoint ステートが変化した時点を指定します。
    @param[in]  current     現在時刻を指定します。

*/
void GenerateStateDuration(
    StateDuration *pOut,
    const StateChangePoint& changePoint,
    nn::TimeSpanType current) NN_NOEXCEPT;

}}}}}
